function [invKin] = inverseKinematics( x, y, z, roll, tilt )
%Inputs: x,y,z position in mm and roll and tilt angles in radians of force
%sensor origin 
%Outputs: z1,z2,z3 positions of the linear actuators in mm,
%roll and tilt angles in radians

[xi yi L d2r r2t t2f f2tool] = deltaParams_mk2();

%compute xyz for the rotary parts and subtract from input xyz to get delta
%xyz

rotaryPos = d2r + Rx(roll)*(r2t + Ry(tilt)*(t2f + f2tool));

xdelta = x-rotaryPos(1);
ydelta = y-rotaryPos(2);
zdelta = z-rotaryPos(3);

zi = zdelta-sqrt(L^2-(xdelta-xi).^2-(ydelta-yi).^2);

z1 = zi(1);
z2 = zi(2);
z3 = zi(3);

invKin = [ z1; z2; z3; roll; tilt ];
end

